/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#ifndef __HELPER_H__
#define __HELPER_H__

CK_ULONG Code2Text(CK_ULONG  ulCode, CK_ULONG  ulTableIdent, CK_BBOOL* pbRet);
void ToUpper (LPTSTR buffer);
void GetString (LPCTSTR text, TCHAR *buffer, int buffer_size);
void GetMenuChoice (int nMenuMin, int nMenuMax, int *pnMenuChoice);
void GetPIN (LPCTSTR message, CK_UTF8CHAR_PTR* pPIN, CK_ULONG* pulPinLen);

/* defines */
#define MAX_SLOT_NUM 10
#define PKCS_SPL_STRYES	 _T("Y")
#define PKCS_SPL_STRNO	 _T("N")
#define PKCS_SPL_STRQUIT _T("Q")

/* Macros */
#define _CK(a)		((CK_CHAR_PTR)(a))
#define IS_HEX(c)   ( ((c)>='0' && (c)<='9') || \
                      ((c)>='a' && (c)<='f') || \
                      ((c)>='A' && (c)<='F') ) 
#define CHAR_HEX(c) (((c)>='0' && (c)<='9') ? ((c) - '0') : ( ((c)>='a' && (c)<='f') ? ((c)-'a'+0x0a) : ((c)-'A'+0x0a) ))

/* Structs */
typedef struct
{
    CK_ULONG       Code; /* identifier info code */
    CK_CHAR_PTR    Text; /* identifier info string */
}PKCS_SPL_TS_TextCode;

typedef struct
{
    CK_ULONG               ulTbl_Ident;   /* text/code array identifier */
    PKCS_SPL_TS_TextCode  *pTbl_TextCode; /* pointer to text/code array */
}PKCS_SPL_TS_TextCodeList;

/* Enums */
typedef enum
{
    PKCS_SPL_END_LIST = 0,
    PKCS_SPL_PRT_VAL,
    PKCS_SPL_RET_CODE,
    PKCS_SPL_SESSION,
    PKCS_SPL_SESSION_NUM,
    PKCS_SPL_SESSION_ST,
    PKCS_SPL_SESSION_FLG,
    PKCS_SPL_KEY_ATTRB,
    PKCS_SPL_KEY_TYPE,
    PKCS_SPL_KEY_GEN,
    PKCS_SPL_MECHA_TYPE,
    PKCS_SPL_OBJ_TYPE,
    PKCS_SPL_LAST_ITEM
}PKCS_SPL_TE_ItemList;

#endif // __HELPER_H__
